// // Copyright (c) Microsoft. All rights reserved.
// // Licensed under the MIT license. See LICENSE file in the project root for full license information.

namespace GraphingCalculatorDemo
{
    public class Settings
    {
        public const string UMin = "u Min";
        public const string UMax = "u Max";
        public const string UGrid = "u GridSections";
        public const string VMin = "v Min";
        public const string VMax = "v Max";
        public const string VGrid = "v GridSections";
        public const string XMin = "x Min";
        public const string XMax = "x Max";
        public const string YMin = "y Min";
        public const string YMax = "y Max";
        public const string XMin2D = "x Min";
        public const string XMax2D = "x Max";
        public const string YMin2D = "y Min";
        public const string YMax2D = "y Max";
        public const string Min2D = "t Min";
        public const string Max2D = "t Max";
        public const string Step2D = "t Step";
        public const string UMinReg = "uMin";
        public const string UMaxReg = "uMax";
        public const string UGridReg = "uGrid";
        public const string VMinReg = "vMin";
        public const string VMaxReg = "vMax";
        public const string VGridReg = "vGrid";
        public const string XMinReg = "xMin";
        public const string XMaxReg = "xMax";
        public const string YMinReg = "yMin";
        public const string YMaxReg = "yMax";
        public const string XMin2DReg = "xMin2D";
        public const string XMax2DReg = "xMax2D";
        public const string YMin2DReg = "yMin2D";
        public const string YMax2DReg = "yMax2D";
        public const string Min2DReg = "tMin2D";
        public const string Max2DReg = "tMax2D";
        public const string Step2DReg = "tStep2D";
        public const string UMinDefault = "-pi";
        public const string UMaxDefault = "pi";
        public const string UGridDefault = "24";
        public const string VMinDefault = "0";
        public const string VMaxDefault = "pi";
        public const string VGridDefault = "48";
        public const string XMinDefault = "-10";
        public const string XMaxDefault = "10";
        public const string YMinDefault = "-10";
        public const string YMaxDefault = "10";
        public const string XMin2DDefault = "-10";
        public const string XMax2DDefault = "10";
        public const string YMin2DDefault = "-10";
        public const string YMax2DDefault = "10";
        public const string Min2DDefault = "0";
        public const string Max2DDefault = "10pi";
        public const string Step2DDefault = "pi/16";
        public const string Fx = "x( u,v )=";
        public const string Fy = "y( u,v )=";
        public const string Fz = "z( u,v )=";
        public const string Y = "y=";
        public const string Xt = "x( t )=";
        public const string Yt = "y( t )=";
        public const string FxReg = "fx";
        public const string FyReg = "fy";
        public const string FzReg = "fz";
        public const string YReg = "y";
        public const string XtReg = "xt";
        public const string YtReg = "yt";
        public const string FxDefault = "cos(u)sin(v)";
        public const string FyDefault = "-cos(v)";
        public const string FzDefault = "sin(-u)sin(v)";
        public const string YDefault = "x*sin(x^2)+x";
        public const string XtDefault = "sin(t)*t/pi";
        public const string YtDefault = "cos(t)*t/pi";
        public const string Function = "2D";
        public const string Function2D = "2D Parametric";
        public const string Function3D = "3D Parametric";
        public const string FunctionNone = "None";
    }
}